package com.tyoma.familyMap;
import java.util.*;
import java.io.*;

class FileToHash {
    
    static Hashes getHashFamilyMap(MetaData metaData) {
        Hashes hashes = new Hashes();
        String inIdRun = null;
        String famIdRun = null;
        int eventF = -1;
        try {
            FileInputStream fis = new FileInputStream(metaData.fileName);
            InputStreamReader file = new InputStreamReader(fis, metaData.encode);
            BufferedReader buff = new BufferedReader(file);
            boolean eof = false;
            while (!eof) {
                String line = buff.readLine();
                if (line == null) {
                    eof = true;
                }
                else {
                    if (line.startsWith("0 @I")) {
                        famIdRun = null;
                        inIdRun = readIndividId(line, hashes.individs);
                    }
                    if (inIdRun != null) eventF = readIndividProp(line, inIdRun, eventF, hashes.individs);
                    if (line.startsWith("0 @F")) {
                        inIdRun = null;
                        famIdRun = readFamilyId(line,hashes.families);
                    }
                    if (famIdRun != null) eventF = readFamilyProp(line, famIdRun, eventF, hashes.families);
                }
            }
            buff.close();
            hashes.key = adjustKey(metaData.key, hashes.individs);
        } catch (IOException e) {
        }
        return hashes;
    }
    
    static String readIndividId(String line, Hashtable hash) {
        Individ indi = new Individ();
        String lineshort = line.substring(3);
        String inIdRun = line.substring(2, lineshort.indexOf("@") + 4);
        indi.inId = inIdRun;
        hash.put(inIdRun, indi);
        return inIdRun;
    }
    
    static int readIndividProp(String line, String inIdRun, int eventF, Hashtable hash) {
        Individ individ = (Individ) hash.get(inIdRun);
        if (line.startsWith("1 NAME"))
            individ.name = line.substring(7);
        if (line.startsWith("2 _HEBN"))
            individ.hebn = line.substring(8);
        if (line.startsWith("2 _AKAN"))
            individ.akan = line.substring(8);
        if (line.startsWith("1 SEX"))
            individ.sex = line.substring(6);
        if (line.startsWith("1"))
            eventF = -1;
        if (line.startsWith("1 BIRT"))
            eventF = 0;
        if (line.startsWith("2 DATE") && eventF == 0)
            individ.birth.date = line.substring(7);
        if (line.startsWith("2 PLAC") && eventF == 0)
            individ.birth.place = line.substring(7);
        if (line.startsWith("1 DEAT"))
            eventF = 1;
        if (line.startsWith("2 DATE") && eventF == 1)
            individ.death.date = line.substring(7);
        if (line.startsWith("2 PLAC") && eventF == 1)
            individ.death.place = line.substring(7);
        if (line.startsWith("1 NOTE"))
            individ.note = line.substring(7);
        if (line.startsWith("1 FAMC"))
            individ.parents = line.substring(7);
        if (line.startsWith("1 FAMS"))
            individ.families.add(line.substring(7));
        hash.put(inIdRun, individ);
        return eventF;
    }
    
    static String readFamilyId(String line, Hashtable hash) {
        Family fami = new Family();
        String lineshort = line.substring(3);
        String famIdRun = line.substring(2, lineshort.indexOf("@") + 4);
        fami.famId = famIdRun;
        hash.put(famIdRun, fami);
        return famIdRun;
    }
    
    static int readFamilyProp(String line, String famIdRun, int eventF, Hashtable hash) {
        Family family = (Family) hash.get(famIdRun);
        if (line.startsWith("1 HUSB"))
            family.husband = line.substring(7);
        if (line.startsWith("1 WIFE"))
            family.wife = line.substring(7);
        if (line.startsWith("1"))
            eventF = -1;
        if (line.startsWith("1 MARR"))
            eventF = 0;
        if (line.startsWith("2 DATE") && eventF == 0)
            family.marriage.date = line.substring(7);
        if (line.startsWith("2 PLAC") && eventF == 0)
            family.marriage.place = line.substring(7);
        if (line.startsWith("1 CHIL"))
            family.children.add(line.substring(7));
        hash.put(famIdRun, family);
        return eventF;
    }
    
    static String adjustKey(String key,Hashtable hash) {
        if (key == null || !hash.containsKey(key)) {
            Set individSet = hash.keySet();
            if (!individSet.isEmpty()) {
                key = (String) individSet.iterator().next();
            }
        }
        return key;
    }
}