package com.tyoma.familyMap;
import java.util.*;
import java.util.regex.PatternSyntaxException;

class HashToXML {
    Hashes hashes = null;
    StringBuffer output = null;
    StringBuffer sb1 = new StringBuffer();
    StringBuffer sb2 = new StringBuffer();
    StringBuffer sb3 = new StringBuffer();
    StringBuffer sb4 = new StringBuffer();
    
    HashToXML(Hashes hashes) {
        this.hashes = hashes;
    }
    void getFamilyMap(String outputMeta, StringBuffer output) {
        this.output = output;
        boolean noPar = true;
        String key = hashes.key;
        String fulFa = "@00000000000@";
        String relat = "";
        output.append("<PERSON ");
        output.append(outputMeta);
        getPerson(key, fulFa, noPar, relat);
        output.append("</PERSON>\n");
    }
    void getSex(Individ individ) {
        if (individ.sex != null){
            output.append(" SEX=\"");
            output.append(individ.sex);
            output.append("\"");
        }
    }
    void getName(Individ individ) {
        if (individ.name != null) {
            output.append("<NAME>\n");
            try {
                String[] names = individ.name.split("/");
                String given = names[0].trim();
                if (given.length() > 0) {
                    output.append("<GIVEN>");
                    output.append(given);
                    output.append("</GIVEN>\n");
                }
                if (names.length > 1 && names[1].trim().length()>0) {
                    output.append("<SURNAME>");
                    output.append(names[1].trim());
                    output.append("</SURNAME>\n");
                }
                if (individ.hebn != null && individ.hebn.length() > 0) {
                    output.append("<HEBN>");
                    output.append(individ.hebn);
                    output.append("</HEBN>\n");
                }
                if (individ.akan != null && individ.akan.length() > 0) {
                    output.append("<AKAN>");
                    output.append(individ.akan);
                    output.append("</AKAN>\n");
                }
            }
            catch (PatternSyntaxException eps) {}
            output.append("</NAME>\n");
        }
    }
    void getBirth(Individ individ) {
        Event event = (Event) individ.birth;
        if (event.date != null || event.place != null) {
            output.append("<BUTTON  ITEM=\"BIRTH\">\n");
            getDate(event);
            getPlace(event);
            output.append("</BUTTON>\n");
        }
    }
    void getDeath(Individ individ) {
        Event event = (Event) individ.death;
        if (event.date != null || event.place != null) {
            output.append("<BUTTON  ITEM=\"DEATH\">\n");
            getDate(event);
            getPlace(event);
            output.append("</BUTTON>\n");
        }
    }
    void getNote(Individ individ) {
        if (individ.note != null) {
            output.append("<BUTTON  ITEM=\"NOTE\">");
            output.append(individ.note);
            output.append("</BUTTON>\n");
        }
    }
    void getDate(Event event) {
        if (event.date != null) {
            output.append("<DATE>");
            output.append(event.date);
            output.append("</DATE>\n");
        }
    }
    void getPlace(Event event) {
        if (event.place != null) {
            output.append("<PLACE>");
            output.append(event.place);
            output.append("</PLACE>\n");
        }
    }
    void getFamily(Individ individ, String fullFa, String relat) {
        String fulInd = "@000000000@";
        String key = individ.inId;
        String relatS = relat + "S";
        String relatC = relat + "C";
        for (int i=0; i < individ.families.size(); i++) {
            String famKey = (String) individ.families.get(i);
            if (famKey.equals(fullFa))	continue;
            Family family = (Family) hashes.families.get(famKey);
            output.append("<BUTTON  ITEM=\"FAMILY\">\n");
            getSpouse(family, key, relatS);
            getChild(family, fulInd, relatC);
            output.append("</BUTTON>\n");
        }
    }
    void getSpouse(Family family, String key, String relatS) {
        boolean noPar = true;
        String famid = family.famId;
        String spouseId = null;
        if (family.husband != null && family.wife != null) {
            if (!(family.husband.equals(key))) spouseId = family.husband;
            if (!(family.wife.equals(key))) spouseId = family.wife;
            if (!(spouseId == null)) {
                output.append("<SPOUSE ");
                getPerson(spouseId, famid,noPar,relatS);
                output.append("\n</SPOUSE>\n");
            }
        }
    }
    void getChild(Family family, String key, String relatC) {
        String faInd = "@000000000@";
        boolean parFla = false;
        for (int i=0; i < family.children.size(); i++) {
            String indKey = (String)family.children.get(i);
            if (indKey.equals(key)) continue;
            output.append("<CHILD ");
            getPerson(indKey, faInd, parFla, relatC);
            output.append("\n</CHILD>\n");
        }
    }
    void getPerson(String key, String fulFa, boolean parFla, String relat) {
        if (hashes.individs.containsKey(key)) {
            Individ individ = (Individ) hashes.individs.get(key);
            String relat1 = relat + individ.sex;
            output.append("ID =\"");
            output.append(key);
            output.append("\"");
            getSex(individ);
            output.append(">\n");
            getName(individ);
            getBirth(individ);
            getDeath(individ);
            getNote(individ);
            getFamily(individ, fulFa, relat1);
            if (parFla) getParents(individ, relat1);
            getRelation(relat1);
            hashes.individs.remove(key);
        }
    }
    void getParents(Individ individ, String relat) {
        String ret = "";
        String relatP = relat + "P";
        String relatG = relat + "G";
        String famKey = (String) individ.parents;
        String key = (String) individ.inId;
        if (famKey != null && hashes.families.containsKey(famKey)) {
            Family family = (Family) hashes.families.get(famKey);
            output.append("<BUTTON  ITEM=\"PARENTS\">\n");
            getFather(family, famKey, relatP);
            getMother(family, famKey, relatP);
            getChild(family, key, relatG);
            output.append("</BUTTON>\n");
        }
    }
    void getFather(Family family, String famKey, String relatP) {
        boolean parFla = true;
        if (family.husband!=null) {
            output.append("<FATHER ");
            getPerson(family.husband, famKey,parFla, relatP);
            output.append("\n</FATHER>\n");
        }
    }
    void getMother(Family family, String famKey, String relatP) {
        boolean parFla = true;
        if (family.wife!=null) {
            output.append("<MOTHER ");
            getPerson(family.wife, famKey,parFla, relatP);
            output.append("\n</MOTHER>\n");
        }
    }
    void getRelation(String relat) {
        sb1.setLength(0);
        sb2.setLength(0);
        sb3.setLength(0);
        sb4.setLength(0);
        
        for (int i=0; i < relat.length(); i++) {
            char tok = relat.charAt(i);
            char tok1 = tok;
            sb1.append('<');
            sb1.append(tok);
            sb1.append('>');
            sb2.insert(0,"</");
            sb2.insert(2,tok);
            sb2.insert(3,'>');
            if (tok == 'P') tok1 = 'C';
            if (tok == 'C') tok1 = 'P';
            sb3.insert(0,'<');
            sb3.insert(1,tok1);
            sb3.insert(2,'>');
            sb4.append("</");
            sb4.append(tok1);
            sb4.append('>');
        }
        output.append("<RELATTO><B>");
        output.append(sb1);
        output.append("<E/>");
        output.append(sb2);
        output.append("</B></RELATTO>\n<RELATFROM><B>");
        output.append(sb3);
        output.append("<E/>");
        output.append(sb4);
        output.append("</B></RELATFROM>");
    }
}
