package com.tyoma.resume;

import javax.servlet.http.*;
import javax.servlet.*;
import java.util.*;
import java.io.*;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.MimeConstants;
import java.net.*;

public class xmlResume extends HttpServlet {
    
    ResourceBundle rb;
    
    public void service(HttpServletRequest request, HttpServletResponse response)
    throws javax.servlet.ServletException, java.io.IOException {
        rb = ResourceBundle.getBundle("com.tyoma.resume.Properties");
        try {
            URL sourceURL = getSourceURL(request.getParameter("source"),request.getServerPort(), request.getServerName());
            ArrayList typesList = getTypes(request);
            for (int p=0;p< typesList.size(); ++p)
                generateResume((String)typesList.get(p),
                request.getParameter("password"),
                p == typesList.size()-1,
                request.getHeader("User-Agent"),
                response,
                request.getParameter("firstname"),
                request.getParameter("lastname"),
                request.getParameter("upload"),
                sourceURL
                );
        } catch (Exception e) {
            try {
                java.io.PrintWriter out = response.getWriter();
                e.printStackTrace(System.err);
                response.setContentType("text/html; charset=ISO-8859-1");
                out.print("<h2>" + e.toString() +"</h2>");
                e.printStackTrace(out);
                out.close();
            } catch (IOException IOe) {System.out.println("Unable to get Writer");}
        }
    }
    private ArrayList getTypes(HttpServletRequest request) {
        ArrayList typesList = new ArrayList();
        String password = request.getParameter("password");
        String typeSingle = request.getParameter("type");
        String [] types = request.getParameterValues("types");
        if (password != null ) {
            if (types != null) {
                for (int p=0;p< types.length; ++p) {
                    if (types[p] != null && types[p].trim().length() > 0)
                        typesList.add(types[p]);
                }
            }
        }
        else {
            if (typeSingle != null && typeSingle.trim().length() > 0) typesList.add(typeSingle.trim());
        }
        if (typesList.isEmpty()) typesList.add(".orig.xml");
        return typesList;
    }   
    private void generateResume(String type, String password, boolean last, String agent, HttpServletResponse response,
    String firstName,String lastName,String upload, URL sourceURL) 
    throws IOException,FileNotFoundException,TransformerConfigurationException,
    TransformerException,org.apache.fop.apps.FOPException 
    {    
        String mimeType = rb.getString("mime"+type);
        String xsltUrl = setXslt(type,password,agent);
        System.out.println("FOP ExampleXML2PDF\n");
        if (password != null )
            writeToFile(password,type,xsltUrl,mimeType,last, response, firstName, lastName,upload, sourceURL);
        else
            outputToBrowser(type,xsltUrl,mimeType, response,upload, sourceURL);
    }
    private String setXslt(String type, String password, String agent) {
        String xsltUrl = rb.getString("xslt"+type);
        if (type.equals(".xml") && agent.indexOf("Gecko") > -1 && password == null)
            xsltUrl = rb.getString("xslt.xmlG");
        return xsltUrl;
    }
    private void writeToFile(String password,String type, String xsltUrl, String mimeType,
    boolean last, HttpServletResponse response, String firstName,String lastName,String upload,URL sourceURL)
    throws IOException,FileNotFoundException,TransformerConfigurationException,
    TransformerException,org.apache.fop.apps.FOPException {
        java.io.PrintWriter out = response.getWriter();
        response.setContentType("text/html; charset=ISO-8859-1");
        if (password.equals(rb.getString("password"))) {
            String outputDest = setOutputDest(type, firstName, lastName);
            if (xsltUrl == null || mimeType.startsWith("text")) {
                java.io.FileWriter outFile = new FileWriter(outputDest);
                writeData(xsltUrl,mimeType, outFile,null,upload,sourceURL);
                outFile.flush();
                outFile.close();
            }
            else {
                FileOutputStream fileOutputStream = new FileOutputStream(outputDest);
                BufferedOutputStream outStream = new BufferedOutputStream(fileOutputStream);
                writeData(xsltUrl,mimeType,new StringWriter(),outStream,upload,sourceURL);
                outStream.close();
            }
            out.print(outputDest + " generated <br/>");
        }
        else {
            out.print("incorrect password");
            out.close();
        }
        if (last) out.close();
    }
    private void outputToBrowser(String type,String xsltUrl, String mimeType, HttpServletResponse response,
    String upload, URL sourceURL)
    throws IOException,FileNotFoundException,TransformerConfigurationException,
    TransformerException,org.apache.fop.apps.FOPException {
        response.setContentType(mimeType+ "; charset=ISO-8859-1");
        if (xsltUrl == null || mimeType.startsWith("text")) {
            java.io.PrintWriter out = response.getWriter();
            writeData(xsltUrl,mimeType,out,null,upload,sourceURL);
            out.close();
        }
        else {
            BufferedOutputStream outStream = new BufferedOutputStream(response.getOutputStream());
            writeData(xsltUrl,mimeType,new StringWriter(),outStream,upload,sourceURL);
            outStream.close();
        }
    }
    
    private String setOutputDest(String type, String firstName, String lastName) {
        String outputDest = null;
        if (firstName != null && firstName.trim().length()>0) outputDest = firstName.trim();
        if (lastName != null && lastName.trim().length()>0) {
            if (outputDest != null ) {
                outputDest += "_" + lastName.trim();
            }
            else {
                outputDest = lastName.trim();
            }
        }
        if (outputDest == null ) outputDest = rb.getString("randomName") + new Random().nextInt();
        outputDest = rb.getString("output.path") + outputDest;
        if (type != null && type.equals(".htm")) outputDest += "_.xml";
        else {
            if (type != null && type.equals(".xmlG")) outputDest += "_G.xml";
            else {
                outputDest += type;
                if (type != null && type.equals(".txt")) outputDest += ".html";
                if (type == null || type.trim().length() == 0) outputDest += ".XML";
            }
        }
        return outputDest;
    }
    private void writeData(String xsltUrl, String mimeType, Writer out, BufferedOutputStream outStream,
    String upload,URL sourceURL)
    throws IOException,TransformerConfigurationException,TransformerException,org.apache.fop.apps.FOPException {
        System.out.print(xsltUrl);
        StreamSource xmlfile = getSource(upload,sourceURL);
        Source xsltfile = new StreamSource(new URL(rb.getString("transformation.path")+ xsltUrl).openStream());
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(xsltfile);
        if (mimeType.startsWith("text")) {
            java.io.StringWriter stringWriter = new StringWriter(1000);
            transformer.transform(xmlfile, new StreamResult(stringWriter));
            StringBuffer stringBuffer = stringWriter.getBuffer();
            out.write(stringBuffer.toString());
        }
        else {
            Fop fop = new Fop(mimeType);
            fop.setOutputStream(outStream);
            transformer.setParameter("versionParam", "2.0");
            Result res = new SAXResult(fop.getDefaultHandler());
            System.out.println("before transform");
            transformer.transform(xmlfile, res);
        }
    }
    
    private StreamSource getSource(String inputText, URL sourceURL) throws MalformedURLException, IOException {
        StreamSource source = null;
        if (inputText != null && inputText.trim().length()>0) {
            CharArrayReader arrayReader = new CharArrayReader(inputText.toCharArray());
            source = new StreamSource(arrayReader);
        }
        else {
            source = new StreamSource(sourceURL.openStream());
        }
        return source;
    }
    
    private URL getSourceURL(String urlString,int port,String serverName) throws MalformedURLException {
        if (urlString == null || urlString.trim().length() == 0) urlString = rb.getString("source.file");
        if (!urlString.startsWith("/") && !urlString.toLowerCase().startsWith("http")) urlString = rb.getString("source.path") + urlString;
        if (urlString.startsWith("/") && port != 80) urlString = ":" + port + urlString;
        if (!urlString.toLowerCase().startsWith("http")) urlString = "http://" + serverName + urlString;
        return new URL(urlString);
    }
}